<?php

namespace App\Http\Controllers\Owner\Group;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Group\Application\UpdateStatus\UpdateGroupStatusQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Http\Request;

class GroupUpdateStatusController extends Controller
{
    private $domain;

    public function __construct(private QueryBus $queryBus)
    {
        $this->domain = "Group";
    }

    public function __invoke(Request $request)
    {
        /** @var UpdateStatusGroupResponse $response */
        $response = $this->queryBus->ask(new UpdateGroupStatusQuery($request->input('Id_Group'), $request->input('Id_StatusGroup')));
        return ResponseBuilder::Response($response->response());
    }
}
