<?php

namespace App\Http\Controllers\Owner\Group;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Group\Application\ListGroupProgramming\ListGroupProgrammingQuery;
use App\Modules\Group\Application\ListGroupProgramming\ListGroupProgrammingResponses;
use App\Modules\Group\Infraestructure\GroupValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class GroupProgrammingListController extends Controller
{
    private $domain;

    public function __construct(private QueryBus $queryBus)
    {
        $this->domain = "Group";
    }

    public function __invoke(Request $request, $action)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, GroupValidators::PROGRAMMING_LIST);

        /** @var ListGroupProgrammingResponses $response */
        $response = $this->queryBus->ask(new ListGroupProgrammingQuery(
            $action,
            $request->get('Id_CategoryTour'),
            $request->get('Id_Tour'),
            $request->get('DateStart'),
            $request->get('DateEnd'),
            $request->header('Token', '')
        ));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
