<?php

namespace App\Http\Controllers\Owner\FactReceiptDetail;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactReceiptDetail\Application\FactReceiptDetailResponses;
use App\Modules\FactReceiptDetail\Application\List\FactReceiptDetailListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptDetailListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($IdFactReceipt, $Action)
    {
        /** @var FactReceiptDetailResponses $response */
        $response = $this->queryBus->ask(new FactReceiptDetailListerQuery($IdFactReceipt, $Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
