<?php
namespace App\Http\Controllers\Owner\FactReceipt;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactReceipt\Application\FactReceiptResponse;
use App\Modules\FactReceipt\Application\Index\FactReceiptIndexerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactReceiptIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var FactReceiptResponse $response */
        $response = $this->queryBus->ask(new FactReceiptIndexerQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
