<?php
namespace App\Http\Controllers\Owner\External;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\External\Application\ExternalDeleter;
use App\Modules\External\Domain\IdExternal;
use App\Modules\External\Infraestructure\MysqlExternalRepository;

class ExternalDeleteController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->history = new HistoryData(HistoryTables::EXTERNAL);
    }

    public function __invoke(Request $Request, int $Id)
    {
        $this->history->obtainOld($Id);

        $response = (new ExternalDeleter(new MysqlExternalRepository()))
            ->__invoke(new IdExternal($Id));

        $this->history->deleteBasic($Id, $Request);

        return ResponseBuilder::Response($response);
    }
}
