<?php

namespace App\Http\Controllers\Owner\CashMovementFactReceipt;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\CashMovementFactReceipt\Application\CashMovementFactReceiptResponses;
use App\Modules\CashMovementFactReceipt\Application\List\ListCashMovementFactReceiptQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class CashMovementFactReceiptListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($IdCashMovement, $Action)
    {
        /** @var CashMovementFactReceiptResponses $response */
        $response = $this->queryBus->ask(new ListCashMovementFactReceiptQuery($IdCashMovement, $Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
