<?php

namespace App\Http\Controllers\Owner\Briefing;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Briefing\Application\BriefingResponses;
use App\Modules\Briefing\Application\List\BriefingListerQuery;
use App\Modules\Briefing\Application\List\ListBriefingQuery;
use App\Modules\Briefing\Infrastructure\BriefingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class BriefingListController extends Controller
{
    private string $domain = 'Briefing';

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, BriefingValidators::LIST);

        /** @var BriefingResponses $response */
        $response = $this->queryBus->ask(new ListBriefingQuery(
            $request->input('DateStart') . ' 00:00:00',
            $request->input('DateEnd') . ' 23:59:59',
            $request->input('Type'),
            $request->input('OrderBy'),
        ));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
