<?php

namespace App\Http\Controllers\Owner\BookingTourPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

final class BookingTourPassengerAllItemsController extends Controller
{
    private $domain;
    public function __construct(
        private CommandBus $commandBus,
        private QueryBus $queryBus
    ) {
        $this->domain = "Booking Tour Passenger";
    }

    public function __invoke(Request $request, $Id_BookingTourPassenger)
    {
        $oResponse  = array();

        $upgrade  = DB::select('call sp_booking_upgrade_passenger_list(?,?)', [0, $Id_BookingTourPassenger]);
        $extra  = DB::select('call sp_booking_extra_passenger_list(?,?)', [0, $Id_BookingTourPassenger]);
        $equipment  = DB::select('call sp_booking_equipment_passenger_list(?,?)', [0, $Id_BookingTourPassenger]);

        $oResponse["Response_Status"]           = 200;
        $oResponse["Response_Code"]             = 200;
        $oResponse["Response_Domain"]           = $this->domain;
        $oResponse["Response_Message"]          = $this->domain . " list";
        $oResponse["Response_Data"]             = array_merge($upgrade, $extra, $equipment);
        $oResponse["Response_Error_Message"]    = "";
        $oResponse["Response_Error_Reason"]     = "";
    

        return ResponseBuilder::Response($oResponse);
    }
}
