<?php

namespace App\Http\Controllers\Owner\BookingTour;

use App\Http\Controllers\Owner\BookingCreator;
use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingTourPassenger\Application\BookingTourPassengerNotificationCreator;
use App\Modules\HtlCampBooking\Application\CreateWithPassengers\CreateWithPassengersHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\List\ListHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\Update\UpdateHtlCampBookingQuery;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerStatus;
use App\Modules\HtlCampSchedule\Application\ReloadAmount\ReloadAmountHtlCampScheduleQuery;
use App\Modules\PackageRate\Domain\PackageRateType;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\TourHtlCamp\Application\List\ListTourHtlCampQuery;
use App\Modules\TourHtlCamp\Application\List\ListTourHtlCampResponse;
use App\Providers\ExcelReport\Utils;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BookingTourChangeController
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private CommandBus $commandBus,
        private BookingCreator $bookingCreator,
        private QueryBus $queryBus,
        private PassengerUpdater $passengerUpdater
    ) {
        $this->oDomain = "Booking Tour";
        $this->history = new HistoryData(HistoryTables::BOOKING_TOUR);
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, ['BookingTour_Value' => 'required|string']);
        $oResponse  = [];
        $continue = true;

        $BookingTour_Value = json_decode($Request->input("BookingTour_Value"));

        $bookingTours = [];

        foreach ($BookingTour_Value as $i => $BookingTour) {
            $this->history->obtainOld($BookingTour->Id_BookingTour);
            $bookingTours[$i] = [];
            $d = DB::select('call sp_booking_tour_index(?)', [$BookingTour->Id_BookingTour]);
            $bookingTours[$i][0] = DB::select('call sp_booking_tour_index(?)', [$BookingTour->Id_BookingTour])[0];

            $packageRate = new PackageRateType($BookingTour->PackageRate_Type);
            $oParam = array(
                $BookingTour->BookingTour_DateStart,
                $BookingTour->Id_PackageTour,
                $BookingTour->Id_BookingTour,
                $packageRate->value()
            );
            /** @var ListHtlCampBookingResponses $htlCampBooking */
            $htlCampBooking = $this->queryBus->ask(new ListHtlCampBookingQuery($BookingTour->Id_BookingTour, 'active'));
            $oDataTour = DB::select('call sp_booking_tour_change_package(?,?,?,?)', $oParam);

            $bookingTours[$i][1] = DB::select('call sp_booking_tour_index(?)', [$BookingTour->Id_BookingTour])[0];
            $this->repareCamps($htlCampBooking->data(), $bookingTours[$i][1]);

            if ($oDataTour[0]->Response_Success == 1) {
                $oParam = array($BookingTour->Id_BookingTour);
                DB::select('CALL sp_booking_tour_add_items_from_package_tour(?,?)', [$BookingTour->Id_BookingTour, 1]);
            } else {
                $oData = $oDataTour;
                $continue = false;
                break;
            }
            $this->history->obtainNew($BookingTour->Id_BookingTour);
        }

        if ($continue == true) {
            $Path_Thumb     = config("var.PATH_PUBLIC") . config("var.USER_COUNTRY_THUMB");
            $oParam         = array(
                'all',
                $BookingTour_Value[0]->Id_BookingTour,
                0,
                $Path_Thumb
            );
            $oDataPax  = DB::select('call sp_booking_tour_passenger_list(?,?,?,?)', $oParam);
            for ($i = 0; $i < count($oDataPax); $i++) {
                $Id_BookingTour = $BookingTour_Value[0]->Id_BookingTour;
                $Id_Passenger = $oDataPax[$i]->Id_Passenger;
                $BookingTourPassenger_Total = count($oDataPax);
                $oParam = [
                    $Id_BookingTour,
                    $Id_Passenger,
                    $BookingTourPassenger_Total,
                    1
                ];
                $oDataTour  = DB::select('call sp_booking_tour_passenger_price(?,?,?,?)', $oParam);
                $oParam     = array($oDataPax[$i]->Id_Passenger, 1);
                $oDataTour  = DB::select('call sp_invoice_reload(?,?)', $oParam);
            }

            $this->updateBookingTours($Request, $bookingTours);
        }


        if ($continue == true) {
            if ($this->history->oldValue && count($this->history->oldValue)) {
                $this->history->update(
                    $this->history->oldValue[0]->Id_Booking,
                    $this->history->oldValue,
                    $this->history->newValueCache,
                    $Request
                );
            }
            $oData = array(
                array(
                    "Response_Status"   => 200,
                    "Response_Code"     => 200,
                    "Response_Message"  => "Paquete remplazado con éxito",
                    "Response_Reason"   => null
                )
            );

            $oData = json_decode(json_encode($oData));
        }

        $oResponse["Response_Status"]           = $oData[0]->Response_Status;
        $oResponse["Response_Code"]             = $oData[0]->Response_Code;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $oData[0]->Response_Message;
        $oResponse["Response_Data"]             = null;
        $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;

        return ResponseBuilder::Response($oResponse);
    }

    /**
     * @param ListHtlCampBookingResponse[] $tourHtlCamps
     */
    private function repareCamps(array $htlCampBookings, $bookingTour)
    {
        /** @var ListTourHtlCampResponse $tourHtlCamps */
        $tourHtlCamps = $this->queryBus->ask(new ListTourHtlCampQuery($bookingTour->Id_Tour, 'active'));

        foreach ($tourHtlCamps->data()['Response_Data'] as $tourHtlCamp) {
            $expectedDate = date('Y-m-d', strtotime($bookingTour->BookingTour_DateStart . ' + ' . ($tourHtlCamp->TourHtlCamp_Day - 1) . ' day'));
            $found = null;
            foreach ($htlCampBookings as $htlCampBooking) {
                if ($htlCampBooking->Id_HtlCamp == $tourHtlCamp->Id_HtlCamp) {
                    $found = $htlCampBooking;
                }
            }
            if ($found == null) {
                $this->addHtlCampBooking($expectedDate, $bookingTour, $tourHtlCamp);
            } else {
                $realDate = date('Y-m-d', strtotime($found->HtlCampBooking_DateStart));
                if ($expectedDate != $realDate) {
                    $this->updateCampsDate($expectedDate, $found);
                }
            }
        }

        foreach ($htlCampBookings as $htlCampBooking) {
            $found = null;
            foreach ($tourHtlCamps->data()['Response_Data'] as $tourHtlCamp) {
                if ($htlCampBooking->Id_HtlCamp == $tourHtlCamp->Id_HtlCamp) {
                    $found = $tourHtlCamp;
                }
            }
            if ($found == null) {
                $this->deleteHtlCampBooking($htlCampBooking);
            }
        }
    }

    private function updateCampsDate($expectedDate, $found)
    {
        $this->queryBus->ask(new UpdateHtlCampBookingQuery(
            $found->Id_HtlCampBooking,
            $expectedDate . ' 00:00:00',
            $found->HtlCampBooking_Remark,
            $found->HtlCampBooking_Status,
        ));
    }

    private function addHtlCampBooking($expectedDate, $bookingTour, $tourHtlCamp)
    {
        /** @var CreateWithPassengersHtlCampBookingResponse $created */
        $created = $this->queryBus->ask(new CreateWithPassengersHtlCampBookingQuery(
            $expectedDate . ' 00:00:00',
            $tourHtlCamp->Id_HtlCamp,
            $bookingTour->Id_BookingTour,
            []
        ));
        $bookingTourPassengers = DB::select('SELECT `btp`.*
            FROM `t_booking_tour_passenger` `btp` WHERE `Id_BookingTour`=?', [$bookingTour->Id_BookingTour]);
        array_map(function ($btp) use ($created) {
            $this->bookingCreator->addHtlCampBookingPassenger(
                $created->id(),
                $btp->Id_BookingTourPassenger
            );
            $this->passengerUpdater->updateLockHtlCampBookingPassenger($btp->Id_Passenger);
        }, $bookingTourPassengers);
    }

    private function deleteHtlCampBooking($htlCampBooking)
    {
        DB::select(
            'UPDATE `t_htl_camp_booking`
            SET `HtlCampBooking_Status` = 0,
                `HtlCampBooking_Amount` = 0,
                `HtlCampBooking_AmountTotal` = 0
            WHERE `Id_HtlCampBooking` = ?',
            [$htlCampBooking->Id_HtlCampBooking]
        );

        DB::select(
            'UPDATE `t_htl_camp_booking_passenger`
            SET `HtlCampBookingPassenger_Status` = ?
            WHERE `Id_HtlCampBooking` = ?',
            [HtlCampBookingPassengerStatus::NON_EXISTS, $htlCampBooking->Id_HtlCampBooking]
        );
        $this->queryBus->ask(new ReloadAmountHtlCampScheduleQuery($htlCampBooking->Id_HtlCampSchedule));
    }

    public function updateBookingTours(Request $Request, array $bookingTours)
    {
        $notificationCreator = new BookingTourPassengerNotificationCreator($this->commandBus);
        Utils::compose(
            [$this, 'mapData'](
                Utils::compose(
                    [$this, 'mapData'](
                        Utils::compose(
                            [$notificationCreator, 'createNotificationWithMessage'](
                                $Request->header('Token'),
                                'ha sido cambiado de tour. Por favor verificar sus equipamentos.'
                            ),
                            fn($btp) => $btp->Id_BookingTourPassenger
                        )
                    ),
                    fn($idBookingTour) => DB::select(
                        'call sp_booking_tour_passenger_list(?,?,?,?)',
                        ['all', $idBookingTour, 0, '']
                    ),
                    fn($bts) => $bts[1]->Id_BookingTour
                )
            ),
            [$this, 'filterDifferentTour']
        )($bookingTours);
    }

    public function mapData(callable $funct)
    {
        return function (array $data) use ($funct) {
            return array_map($funct, $data);
        };
    }

    public function filterDifferentTour(array $bookingTours)
    {
        return array_filter($bookingTours, fn($bts) => $bts[0]->Id_Tour != $bts[1]->Id_Tour);
    }
}
