<?php

namespace App\ExTypes;

class Selectable {

    private $defaultValue;
    private $values;

    private $currentValue;

    public function __construct(
        $value,
        ?array $values = null
    ) {
        $acceptedValues = $values ?? [];
        if (is_array($value)) {
            $acceptedValues = $value;
        }
        if (isset($acceptedValues[0])) {
            $this->defaultValue = $acceptedValues[0];
        }
        if (!is_array($value)) {
            if (in_array($value, $acceptedValues)) {
                $this->defaultValue = $value;
            }
        }
        $this->values = $acceptedValues;
        $this->currentValue = $this->defaultValue;
    }

    public function setValue($value) {
        $this->currentValue = in_array($value, $this->values) ? $value : $this->defaultValue;
    }

    public function getValue() { return $this->currentValue; }
}