<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class StateMother {
    
    public static function build1($id = 1, $idCountry = 1) {
        return [
            'Id_State'  			=> $id,            
            'State_Code'		    => 'CU',
            'State_Name'		    => 'CUSCO',
            'State_Status'  		=> 2,
            'Id_Country'            => $idCountry
        ];
    }

    public static function push1($id = 1, $idCountry = 1) {
        return self::push(self::build1($id, $idCountry));
    }

    private static function push($object) {
        DB::select("CALL `sp_state_insert` (?,?,?,?)", [
            $object['State_Code'],
            $object['State_Name'],
            $object['State_Status'],
            $object['Id_Country']
        ]);
        return $object;
    }

}