<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PackageTranslMother {

    public static function build1($idPackage = null, $idLanguage = null, $id = 1) {
        $faker = Factory::create();
        $idPackage = $idPackage ?? PackageMother::push1()['Id_Package'];
        $idLanguage = $idLanguage ?? LanguageMother::push1()['Id_Language'];
        return [
            'Id_PackageTransl' => $id,
            'PackageTransl_Title' => Str::title($faker->text(rand(5, 250))),
            'Id_Package' => $idPackage,
            'Id_Language' => $idLanguage
        ];
    }

    public static function push1($idPackage = null, $idLanguage = null, $id = 1) {
        return self::push(self::build1($idPackage, $idLanguage, $id));
    }
    
    private static function push($object) {
        $response = DB::select("CALL `sp_package_transl_insert` (?,?,?,?)", [
            $object['PackageTransl_Title'],
            $object['Id_Package'],
            $object['Id_Language'],
            1
        ]);
        return $object;
    }

}