<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class PackageFeeMother
{

    public static function build1($idPackage = null, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => $faker->randomNumber(8),
            'PackageFee_Full' => $faker->randomElement([1, 2]),
            'PackageFee_Type' => $faker->randomElement([1, 2]),
            'Id_Package' => $idPackage ?? PackageMother::push1()['Id_Package']
        ];
    }

    public static function buildUnfull($idPackage, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => $faker->randomNumber(8),
            'PackageFee_Full' => 1,
            'PackageFee_Type' => 2,
            'Id_Package' => $idPackage
        ];
    }

    public static function buildFull($least, $idPackage, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => rand(5, $least - 1),
            'PackageFee_Full' => 2,
            'PackageFee_Type' => 2,
            'Id_Package' => $idPackage
        ];
    }

    public static function buildShared1($id = 1, $idPackage = 1, $idTypeRate = 1)
    {
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => '100.00',
            'PackageFee_Full' => 2,
            'PackageFee_Type' => 1,
            'Id_Package' => $idPackage
        ];
    }

    public static function push1($idPackage = null, $id = 1)
    {
        return self::push(self::build1($idPackage, $id));
    }

    public static function pushUnFull1($idPackage, $packageAmount, $id = 1)
    {
        return self::push(self::buildUnFull($idPackage, $packageAmount, $id));
    }

    public static function pushFull1($least, $idPackage, $id = 1)
    {
        return self::push(self::buildFull($least, $idPackage, $id));
    }

    public static function pushShared1($id = 1, $idPackage = 1, $idTypeRate = 1)
    {
        return self::push(self::buildShared1($id, $idPackage, $idTypeRate));
    }


    public static function buildShared2($id = 1, $idPackage = 1, $PackageFee_Full = 2)
    {
        return [
            'Id_PackageFee' => $id,
            'PackageFee_Amount' => '50.00',
            'PackageFee_Full' => 2,
            'PackageFee_Type' => 1,
            'Id_Package' => $idPackage
        ];
    }

    public static function pushShared2($id = 1, $idPackage = 1, $PackageFee_Full = 2)
    {
        return self::push(self::buildShared2($id, $idPackage, $PackageFee_Full));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_package_fee_insert` (?,?,?,?)", [
            $object['PackageFee_Amount'],
            $object['PackageFee_Full'],
            $object['PackageFee_Type'],
            $object['Id_Package']
        ]);
        return $object;
    }

    public static function clear()
    {
        return array_merge(
            [
                TableCreation::PACKAGE_FEE
            ],
            PackageMother::clear()
        );
    }
}
