<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class HtlTypeRoomMother
{
    
    public static function build1($idHtlCamp = null, $id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_HtlTypeRoom' => $id,
            'HtlTypeRoom_Name' => $faker->text(rand(5, 250)),
            'HtlTypeRoom_Abrv' => Util::generateString(10),
            'HtlTypeRoom_Status' => $faker->randomElement([1, 2]),
            'Id_HtlCamp' => $idHtlCamp ?? HtlCampMother::push1()['Id_HtlCamp']
        ];
    }

    public static function push1($idHtlCamp = null, $id = 0)
    {
        return self::push(self::build1($idHtlCamp, $id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_htl_type_room`(`Id_HtlTypeRoom`, `HtlTypeRoom_Name`, `HtlTypeRoom_Abrv`, `HtlTypeRoom_Status`, `Id_HtlCamp`)
            VALUES (?,?,?,?,?)", [
            $object['Id_HtlTypeRoom'] == 0 ? null : $object['Id_HtlTypeRoom'],
            $object['HtlTypeRoom_Name'],
            $object['HtlTypeRoom_Abrv'],
            $object['HtlTypeRoom_Status'],
            $object['Id_HtlCamp'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_HtlTypeRoom'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::HTL_TYPE_ROOM, ...HtlCampMother::tablesToClear() ];
    }
}
