<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;
use App\Modules\HtlCamp\Domain\HtlCamp;
use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;

class HtlTypeCampMother
{
    
    public static function build1($id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_HtlTypeCamp' => $id,
            'HtlTypeCamp_Name' => $faker->text(rand(5, 250)),
            'HtlTypeCamp_Abrv' => Util::generateString(10),
            'HtlTypeCamp_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 0)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_htl_type_camp`(`Id_HtlTypeCamp`, `HtlTypeCamp_Name`, `HtlTypeCamp_Abrv`, `HtlTypeCamp_Status`)
            VALUES (?,?,?,?)", [
            $object['Id_HtlTypeCamp'] == 0 ? null : $object['Id_HtlTypeCamp'],
            $object['HtlTypeCamp_Name'],
            $object['HtlTypeCamp_Abrv'],
            $object['HtlTypeCamp_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_HtlTypeCamp'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::HTL_TYPE_CAMP, ...HtlCampMother::tablesToClear() ];
    }
}
