<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;

class FactTypeReceiptMother
{

    public static function pushDefault()
    {
        return self::push(self::build1(IdFactTypeReceipt::defaultValue()));
    }

    public static function build1($id = 0)
    {
        $faker = Factory::create();
        return [
            'Id_FactTypeReceipt' => $id,
            'FactTypeReceipt_Name' => $faker->text(rand(5, 100)),
            'FactTypeReceipt_Abrv' => Util::generateString(10),
            'FactTypeReceipt_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 0)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_fact_type_receipt`(`Id_FactTypeReceipt`,`FactTypeReceipt_Name`,`FactTypeReceipt_Abrv`,`FactTypeReceipt_Status`)
            VALUES (?,?,?,?)", [
            $object['Id_FactTypeReceipt'] == 0 ? null : $object['Id_FactTypeReceipt'],
            $object['FactTypeReceipt_Name'],
            $object['FactTypeReceipt_Abrv'],
            $object['FactTypeReceipt_Status'],
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_FactTypeReceipt'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::FACT_TYPE_RECEIPT];
    }
}
