<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CategoryTourMother {
    
    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_CategoryTour' => $id,
            'CategoryTour_Name' => Str::title($faker->text(rand(5, 250))),
            'CategoryTour_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_category_tour_insert` (?,?)", [
            $object['CategoryTour_Name'],
            $object['CategoryTour_Status']
        ]);
        $object['Id_CategoryTour'] = $response[0]->Response_Id;
        return $object;
    }

}