<?php

namespace App\DBRealTestSupport;

use App\Modules\FactUnit\Domain\FactUnit;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class CashMovementFactReceiptMother
{

    public static function build1($idCashMovement, $idFactReceipt = null, $id = 1)
    {
        $idFactReceipt = $idFactReceipt ?? FactReceiptMother::push1()['Id_FactReceipt'];
        $faker = Factory::create();
        return [
            'Id_CashMovementFactReceipt' => $id,
            'CashMovementFactReceipt_Status' => $faker->randomElement([1, 2]),
            'Id_CashMovement' => $idCashMovement,
            'Id_FactReceipt' => $idFactReceipt,
        ];
    }

    public static function push1($idCashMovement, $idFactReceipt = null, $id = 1)
    {
        return self::push(self::build1($idCashMovement, $idFactReceipt, $id));
    }

    private static function push($object)
    {
        $response = DB::select("INSERT INTO `t_cash_movement_fact_receipt`(
            `CashMovementFactReceipt_Status`,
            `Id_CashMovement`,
            `Id_FactReceipt`
        ) VALUES (?,?,?)", [
            $object['CashMovementFactReceipt_Status'],
            $object['Id_CashMovement'],
            $object['Id_FactReceipt']
        ]);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        $object['Id_CashMovementFactReceipt'] = $response[0]->id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TableCreation::CASH_MOVEMENT_FACT_RECEIPT,
            ...CashMovementMother::tablesToClear(),
            ...FactReceiptMother::tablesToClear(),
            ...FactUnitMother::tablesToClear(),
            ...FactTypeOperationMother::tablesToClear()
        ];
    }
}
