<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;

class BookingUpgradeMother
{
    public static function build1($idProvider, $idBookingTour, $idUpgrade, $id = 1)
    {
        $faker = \Faker\Factory::create();
        return [
            'Id_BookingUpgrade' => $id,
            'BookingUpgrade_Quantity' => 0,
            'BookingUpgrade_Price' => 0,
            'BookingUpgrade_Total' => 3,
            'BookingUpgrade_Feature' => '',
            'BookingUpgrade_Included' => $faker->randomElement([1, 2]),
            'Id_Provider' => $idProvider,
            'Id_BookingTour' => $idBookingTour,
            'Id_Upgrade' => $idUpgrade
        ];
    }

    public static function push1($Id_Provider, $Id_BookingTour, $Id_Upgrade, $id = 1)
    {
        return self::push(self::build1($Id_Provider, $Id_BookingTour, $Id_Upgrade, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_booking_upgrade_insert`(?,?,?,?,?,?,?,?)", [
            $object['BookingUpgrade_Quantity'],
            $object['BookingUpgrade_Feature'],
            $object['BookingUpgrade_Included'],
            $object['Id_BookingTour'],
            $object['Id_Provider'],
            $object['Id_Upgrade'],
            1,
            1
        ]);
        $object['Id_BookingUpgrade'] = $response[0]->Response_Id;
        return $object;
    }
}
