<?php

namespace App\DBRealTestSupport;

use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class BookingMother
{
    public static function credentials()
    {
        return [
            CredentialMother::Text_BriefingPlace,
            CredentialMother::Web_URL
        ];
    }

    public static function init()
    {
        TypeBookingAssignMother::pushBrute1(1);
    }

    public static function realInit()
    {
        TypeBookingAssignMother::pushBrute1(1);
        BookingMother::pushRelationshipAndReferredFrom();
    }

    /**
     * Inserts the default booking relationship and booking referred from
     */
    public static function pushRelationshipAndReferredFrom()
    {
        DB::statement(
            "INSERT INTO `t_booking_relationship` (
                `Id_BookingRelationship`,
                `BookingRelationship_Name`,
                `BookingRelationship_Abrv`,
                `BookingRelationship_Lock`,
                `BookingRelationship_Status`)
                VALUE 
                (1, 'Ninguno', 'NONE', 2, 2)"
        );
        DB::statement(
            "INSERT INTO `t_booking_referred_from` (
            `Id_BookingReferredFrom`,
            `BookingReferredFrom_Name`,
            `BookingReferredFrom_Abrv`,
            `BookingReferredFrom_Lock`,
            `BookingReferredFrom_Status`)
            VALUE
            (1, 'Ninguno', 'NONE', 2, 2)"
        );
    }

    public static function build1(
        $idAdmin,
        $idGuideLanguage,
        $idLanguage,
        $idUser,
        $idBookingRelationship = 1,
        $idBookingReferredFrom = 1,
        $id = 1
    ) {
        return [
            'Id_Booking'                    => $id,
            'Booking_Date'                  => date('Y-m-d H:i:s'),
            'Booking_DateStart'             => date('Y-m-d'),
            'Booking_DateBriefing'          => date('Y-m-d H:i:s', time() + 10 * 60 * 60),
            'Booking_PlaceBriefing'         => 'Place Briefing',
            'Booking_Code'                  => 'Code',
            'Booking_HistoryChanges'        => '',
            'Booking_Hotel'                 => '',
            'Booking_Observation'           => '',
            'Booking_InternalRemark'        => '',
            'Booking_Receipt'               => 1,
            'Booking_Type'                  => 2,
            'Booking_Type_Real'             => 2,
            'Booking_LastMinute'            => 2,
            'Booking_Status'                => 1,
            'Booking_ManuallyConfirmed'     => 1,
            'Booking_InPerson'              => 2,
            'Booking_Token'                 => '',
            'Id_Admin'                      => $idAdmin,
            'Id_GuideLanguage'              => $idGuideLanguage,
            'Id_Language'                   => $idLanguage,
            'Id_User_Additional'            => 0,
            'Id_User'                       => $idUser,
            'Id_BookingRelationship'        => $idBookingRelationship,
            'Id_BookingReferredFrom'        => $idBookingReferredFrom,
        ];
    }

    public static function push1(
        $idAdmin,
        $idGuideLanguage,
        $idLanguage,
        $idUser,
        $token,
        $idBookingRelationship = 1,
        $idBookingReferredFrom = 1,
        $id = 1
    ) {
        return self::push(
            self::build1(
                $idAdmin,
                $idGuideLanguage,
                $idLanguage,
                $idUser,
                $idBookingRelationship,
                $idBookingReferredFrom,
                $id
            ),
            $token
        );
    }

    public static function pushBookingTour($booking, $idPackage = null, $idTour = null)
    {
        $package = $idPackage ?? PackageMother::push1()['Id_Package'];
        $tour = $idTour ?? TourMother::push1()['Id_Tour'];
        PackageTranslMother::push1($package, $booking['Id_Language']);
        TourTranslMother::push1($tour, $booking['Id_Language']);
        return BookingTourMother::pushShared1($booking['Id_Booking'], $package, $tour);
    }

    public static function push($object, $token = '')
    {
        $response = DB::select("CALL `sp_booking_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['Booking_DateStart'],
            $object['Booking_Receipt'],
            $object['Booking_Type'],
            $object['Booking_Observation'],
            $object['Booking_InternalRemark'],
            $object['Id_Language'],
            $object['Id_GuideLanguage'],
            $object['Id_User'],
            $object['Id_User_Additional'],
            $object['Booking_InPerson'],
            $object['Id_BookingRelationship'],
            $object['Id_BookingReferredFrom'],
            $token
        ]);
        $object['Id_Booking'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return array_merge(
            [
                TC::COUNTRY, TC::STATE, TC::CITY, TC::type_tour, TC::category_tour, TC::tour, TC::group,
                TC::booking, TC::booking_referred_from, TC::booking_relationship, TC::package_tour, TC::INVOICE,
                TC::INVOICE_FEE, TC::INVOICE_DETAIL, TC::INVOICE_FEE_DETAIL, TC::package, TC::PACKAGE_FEE,
                TC::PACKAGE_RATE, TC::PACKAGE_TRANSL, TC::passenger, TC::tour_transl, TC::type_rate, TC::type_rate_transl,
                TC::type_tour_transl, TC::user_package_rate, TC::booking_tour_passenger, TC::booking_tour, TC::type_payment,
                TC::type_payment_transl, TC::type_item, TC::type_equipment, TC::item, TC::equipment,
                TC::package_tour_equipment, TC::BOOKING_EQUIPMENT, TC::cash_movement, TC::cash_movement_detail,
                TC::equipment_transl, TC::type_equipment_transl, TC::CREDENTIAL, TC::LANGUAGE,
                TC::TYPE_UPGRADE, TC::TYPE_UPGRADE_TRANSL, TC::BOOKING_UPGRADE, TC::BOOKING_UPGRADE_PASSENGER,
                TC::PACKAGE_TOUR_EXTRA, TC::BOOKING_EXTRA, TC::EXTRA_TRANSL, TC::TYPE_EXTRA_TRANSL,
                TC::PACKAGE_TOUR_UPGRADE, TC::BOOKING_UPGRADE, TC::UPGRADE_TRANSL, TC::TYPE_UPGRADE_TRANSL,
            ],
            TypeBookingAssignMother::tablesToClear(),
            ModuleNotificationMother::clear()
        );
    }

    public static function generatePassenger($typeRate)
    {
        return PassengerMother::build1(0, idTypeRate: $typeRate);
    }

    public static function getBooking()
    {
        return DB::select('SELECT `b`.*, `u`.* FROM `t_booking` AS `b` '
            . 'INNER JOIN `t_user` AS `u` ON `b`.`Id_User` = `u`.`Id_User`')[0];
    }
    public static function getPassengerList($booking)
    {
        return DB::select('SELECT * FROM `t_passenger` WHERE `Id_Booking`=?', [$booking->Id_Booking]);
    }
    public static function getBookingTourList($booking)
    {
        return DB::select('SELECT * FROM `t_booking_tour` WHERE `Id_Booking`=?', [$booking->Id_Booking]);
    }

    public static function getBookingExtraList($bookingTour)
    {
        return DB::select('SELECT * FROM `t_booking_extra` WHERE `Id_BookingTour`=?', [$bookingTour->Id_BookingTour]);
    }

    public static function getBookingUpgradeList($bookingTour)
    {
        return DB::select('SELECT * FROM `t_booking_upgrade` WHERE `Id_BookingTour`=?', [$bookingTour->Id_BookingTour]);
    }

    public static function getBookingExtraPassengerList($bookingExtra)
    {
        return DB::select('SELECT * FROM `t_booking_extra_passenger` WHERE `Id_BookingExtra`=?', [$bookingExtra->Id_BookingExtra]);
    }

    public static function getBookingUpgradePassengerList($bookingUpgrade)
    {
        return DB::select('SELECT * FROM `t_booking_upgrade_passenger` WHERE `Id_BookingUpgrade`=?', [$bookingUpgrade->Id_BookingUpgrade]);
    }

    public static function getInvoiceList($passenger)
    {
        return array_map(
            fn ($pass) => DB::select('SELECT * FROM `t_invoice` WHERE `Id_Passenger`=?', [$pass->Id_Passenger])[0],
            $passenger
        );
    }

    public static function getBookingTourPassengerList($bookingTour)
    {
        $query = 'SELECT * FROM `t_booking_tour_passenger` WHERE `Id_BookingTour`=?';
        return DB::select($query, [$bookingTour->Id_BookingTour]);
    }

    public static function prepare()
    {
        LanguageMother::pushBasicDefault();
        BookingMother::pushRelationshipAndReferredFrom();
        $typeDocument = TypeDocumentMother::push1();
        $userCountry = UserCountryMother::push1();
        return [
            'language' => LanguageMother::pushBasic(),
            'guideLanguage' => LanguageMother::pushBasic(),
            'typeDocument' => $typeDocument,
            'userCountry' => $userCountry,
            'user' => UserMother::push1(
                $typeDocument['Id_TypeDocument'],
                $userCountry['Id_UserCountry']
            ),
        ];
    }
}
