<?php

namespace App\DBRealTestSupport\Booking;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Booking\Domain\BookingStatus;
use App\Modules\Booking\Domain\BookingType;
use App\Modules\Booking\Domain\InsertBookingModel;
use App\Modules\BookingReferredFrom\Domain\IdBookingReferredFrom;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;

class InsertBookingModelBuilder
{

    private BookingType $bookingType;
    private BookingStatus $bookingStatus;
    private ?IdAdmin $idAdmin;
    private ?int $idGuideLanguage;
    private ?int $idLanguage;
    private ?int $idUser;
    private ?IdBookingRelationship $idBookingRelationship;
    private ?IdBookingReferredFrom $idBookingReferredFrom;

    public function __construct()
    {
        $faker = \Faker\Factory::create();
        $this->bookingType = new BookingType($faker->randomElement([BookingType::RESERVA_WEB, BookingType::RESERVA_SISTEMA]));
        $this->bookingStatus = new BookingStatus(BookingStatus::PENDING);
        $this->idAdmin = new IdAdmin(0);
        $this->idGuideLanguage = 0;
        $this->idLanguage = 0;
        $this->idUser = 0;
        $this->idBookingRelationship = new IdBookingRelationship(0);
        $this->idBookingReferredFrom = new IdBookingReferredFrom(0);
    }

    public function withIdAdmin(IdAdmin $idAdmin): InsertBookingModelBuilder
    {
        $this->idAdmin = $idAdmin;
        return $this;
    }

    public function withIdGuideLanguage(int $idGuideLanguage): InsertBookingModelBuilder
    {
        $this->idGuideLanguage = $idGuideLanguage;
        return $this;
    }

    public function withIdLanguage(int $idLanguage): InsertBookingModelBuilder
    {
        $this->idLanguage = $idLanguage;
        return $this;
    }

    public function withIdUser(int $idUser): InsertBookingModelBuilder
    {
        $this->idUser = $idUser;
        return $this;
    }

    public function withIdBookingRelationship(IdBookingRelationship $idBookingRelationship): InsertBookingModelBuilder
    {
        $this->idBookingRelationship = $idBookingRelationship;
        return $this;
    }

    public function withIdBookingReferredFrom(IdBookingReferredFrom $idBookingReferredFrom): InsertBookingModelBuilder
    {
        $this->idBookingReferredFrom = $idBookingReferredFrom;
        return $this;
    }

    public function build(): InsertBookingModel
    {
        return new InsertBookingModel(
            $this->bookingType,
            $this->bookingStatus,
            $this->idAdmin,
            $this->idGuideLanguage,
            $this->idLanguage,
            $this->idUser,
            $this->idBookingRelationship,
            $this->idBookingReferredFrom
        );
    }
    public function saved(): bool
    {
        return true;
    }
}
